/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.rmon.eui;

import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.rmon.eui.RmonEthernetGroup;
import ibm.nways.rmon.eui.RmonTokenRingMLGroup;
import ibm.nways.rmon.eui.RmonTokenRingPGroup;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class RmonGroup
extends NavigationFolder
implements NavigationBrowserEventListener {
    private static ResourceBundle myResources = null;
    private static String title = "Rmon";
    NavigationFolder newfolder;
    protected JdmBrowser browser;
    Object[] args = new Object[1];
    NavigationContext myContext;
    boolean expanded = false;
    GenModel model;

    public RmonGroup(GenModel genModel) {
        this(null, genModel);
    }

    public RmonGroup(JdmBrowser jdmBrowser, GenModel genModel) {
        super(RmonGroup.getTitle(), new NavigationDestination("ibm.nways.jdm.NilDestination", genModel), "Rmon");
        this.browser = jdmBrowser;
        this.model = genModel;
    }

    public void navPointSelected(NavigationPoint navigationPoint) {
    }

    public void navPointDeselected() {
    }

    public void navigationFolderCollapsed(NavigationFolder navigationFolder) {
    }

    public void navigationFolderExpanded(NavigationFolder navigationFolder) {
        NavigationContext navigationContext = this.getNavContext();
        NavigationBrowser navigationBrowser = (NavigationBrowser)navigationContext.get("TREE");
        if (navigationFolder == this && !this.expanded) {
            GenModel genModel;
            try {
                this.args[0] = myResources.getString("RmonEthernetGroupTitle");
                this.displayMsg(MessageFormat.format(myResources.getString("checkModel"), this.args));
                genModel = (GenModel)this.model.getComponent("RmonEthernet");
                if (genModel != null) {
                    this.displayMsg(MessageFormat.format(myResources.getString("addFolder"), this.args));
                    this.newfolder = new RmonEthernetGroup(this.browser, genModel);
                    this.newfolder.setLabel(myResources.getString("RmonEthernetGroupTitle"));
                    this.newfolder.setIsInitiallyExpanded(false);
                    this.add(this.newfolder);
                    navigationBrowser.addEventListener((RmonEthernetGroup)this.newfolder);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                this.args[0] = myResources.getString("RmonTokenRingMLGroupTitle");
                this.displayMsg(MessageFormat.format(myResources.getString("checkModel"), this.args));
                genModel = (GenModel)this.model.getComponent("RmonTokenRingML");
                if (genModel != null) {
                    this.displayMsg(MessageFormat.format(myResources.getString("addFolder"), this.args));
                    this.newfolder = new RmonTokenRingMLGroup(this.browser, genModel);
                    this.newfolder.setLabel(myResources.getString("RmonTokenRingMLGroupTitle"));
                    this.newfolder.setIsInitiallyExpanded(false);
                    this.add(this.newfolder);
                    navigationBrowser.addEventListener((RmonTokenRingMLGroup)this.newfolder);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                this.args[0] = myResources.getString("RmonTokenRingPGroupTitle");
                this.displayMsg(MessageFormat.format(myResources.getString("checkModel"), this.args));
                genModel = (GenModel)this.model.getComponent("RmonTokenRingP");
                if (genModel != null) {
                    this.displayMsg(MessageFormat.format(myResources.getString("addFolder"), this.args));
                    this.newfolder = new RmonTokenRingPGroup(this.browser, genModel);
                    this.newfolder.setLabel(myResources.getString("RmonTokenRingPGroupTitle"));
                    this.newfolder.setIsInitiallyExpanded(false);
                    this.add(this.newfolder);
                    navigationBrowser.addEventListener((RmonTokenRingPGroup)this.newfolder);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.expanded = true;
            this.displayMsg(myResources.getString("expansionComplete"));
        }
    }

    protected void displayMsg(String string) {
        if (this.browser != null) {
            this.browser.displayMsg(string);
        }
    }

    public static String getTitle() {
        try {
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.rmon.eui.RmonGroupResources");
            }
            if (myResources != null) {
                title = myResources.getString("RmonGroupTitle");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to access translation resources for group Rmon");
        }
        return title;
    }
}

